//---------------------------------------------------------------------------

#include <vcl.h>


#include <values.h>
#include <math.h>
#include <stdio.h>
#include <Classes.hpp>


#pragma hdrstop

#include "TProfile.h"
//#include "TKite.h"
#include "Support.h"

//#include "Unit3.h"


AnsiString __fastcall TProfile::GetName(void)
{
	 return Name ;
}

__fastcall TProfile::TProfile(void)
{
   PointCount = 0;
   isloaded = 0;

}

float __fastcall TProfile::GetPointX(int Index) {

	   return PointsX[Index];
}

float __fastcall TProfile::GetPointY(int Index) {

	   return PointsY[Index];
}


int __fastcall TProfile::GetPointCount(void) {

	   return PointCount;
}


int __fastcall TProfile::LoadFromFile(AnsiString FileName)
{
	int i=0, y=0;
	int splitpos=0;
	PointCount=0 ;
	DecimalSeparator = '.';
	FileStrings = new TStringList();
	FileStrings->Clear();
	FileStrings->LoadFromFile(FileName);
	if(FileStrings->Count) {
	  // Assign the name of profile
	  Name = FileStrings->Strings[0];
	  // Clear empty strings
	  for (i=1; i < FileStrings->Count; i++) {
		FileStrings->Strings[i] = FileStrings->Strings[i].Trim();
		if(FileStrings->Strings[i].Length() != 0) 	 PointCount++;
	   }

	y=0;
	  for (i=1; i < FileStrings->Count; i++) {
		  if(FileStrings->Strings[i].Length() != 0) {
		  //split by tab
		 splitpos = FileStrings->Strings[i].Pos("\t");
		 if(!splitpos) 		 splitpos = FileStrings->Strings[i].Pos(" ");
		 if(splitpos) {
			AnsiString x_str = FileStrings->Strings[i].SubString(0,splitpos);
			AnsiString y_str = FileStrings->Strings[i].SubString(splitpos,FileStrings->Strings[i].Length()-splitpos+1);
			x_str = x_str.Trim();
			y_str = y_str.Trim();
			PointsX[y] =  StrToFloat(x_str);
			PointsY[y] =  StrToFloat(y_str);
			y++;


		 }
	   }
	  }
	}
	else {
	 delete FileStrings;
	 return 0;
	}
	 isloaded = 1;
	 delete FileStrings;
	int jt=0,jb=0;
		 TopPointsX[0] = 1.0 ;
		 TopPointsY[0] = 0.0 ;
		 BottomPointsX[0] = 1.0;
		 BottomPointsY[0] = 0.0 ;
   i = 0;
   //      
   if(PointsX[0] == 1.0 ) {
	   while(PointsX[i]!=0.0) {
		TopPointsX[jt] = Roundf(PointsX[i],7);
		TopPointsY[jt] = Roundf(PointsY[i],7);
		i++;
		jt++;
	   }

	   while(i<PointCount) {
		BottomPointsX[jb] = Roundf(PointsX[i],7);
		BottomPointsY[jb] = Roundf(PointsY[i],7);
		i++;
		jb++;
	   }

   }  else
   if(PointsX[0] == 0.0 ) {
	   while(PointsX[i]!=1.0 ) {
		TopPointsX[jt] = Roundf(PointsX[i],7);
		TopPointsY[jt] = Roundf(PointsY[i],7);
		i++;
		jt++;
	   }

	   while(i<PointCount) {
		BottomPointsX[jb] = Roundf(PointsX[i],7);
		BottomPointsY[jb] = Roundf(PointsY[i],7);
		i++;
		jb++;
	   }
   }

	TopPointsCount = jt;
	BottomPointsCount = jb;



	if(TopPointsX[1]>TopPointsX[0]) {
		reverse_array(TopPointsX,TopPointsCount-1);
		reverse_array(TopPointsY,TopPointsCount-1);
	}
	if(BottomPointsX[1]>BottomPointsX[0]) {
		reverse_array(BottomPointsX,BottomPointsCount-1);
		reverse_array(BottomPointsY,BottomPointsCount-1);
	}
   //	BottomPointsX[0]=1;
	int mx = 0,it = 1,ib = 1;
	i = 0 ;
	while(i < TopPointsCount + BottomPointsCount)  {
	  if(TopPointsX[it]>BottomPointsX[ib]) {
		MixedPoints[mx].x = TopPointsX[it];
		MixedPoints[mx].top_y = TopPointsY[it];
		MixedPoints[mx].bot_y = GetY(BottomPointsX[ib-1],BottomPointsY[ib-1],BottomPointsX[ib],BottomPointsY[ib],TopPointsX[it]);// make bottom point
		MixedPoints[mx].top = 0;
		mx++;
		it++;
	  } else
	   if(TopPointsX[it]<BottomPointsX[ib]) {
		MixedPoints[mx].x = BottomPointsX[ib];
		MixedPoints[mx].bot_y = BottomPointsY[ib];
		MixedPoints[mx].top_y = GetY(TopPointsX[it-1],TopPointsY[it-1],TopPointsX[it],TopPointsY[it],BottomPointsX[ib]);// make bottom point
		MixedPoints[mx].top = 1;
		mx++;
		ib++;
	   } else {
		MixedPoints[mx].x = TopPointsX[it];
		MixedPoints[mx].top_y = TopPointsY[it];
		MixedPoints[mx].bot_y = BottomPointsY[ib];
		MixedPoints[mx].top = 2;
		mx++;
		it++;
		ib++;
	   }
   i++;
	}



	MixedPointsCount = mx;
	MaxDepth =0.0;
	float depth;
	for(i=0;i<MixedPointsCount;i++)
	{

	 depth = fabs(MixedPoints[i].top_y - MixedPoints[i].bot_y);//GetDepthAt(TopPointsX[i]);
	 if(depth>MaxDepth) {
		MaxDepth = depth;
		MaxDepthPosition = MixedPoints[i].x;
		  }
	}

	WorkMaxDepth = MaxDepth;
	WorkDepthPosition = MaxDepthPosition;
	for(i=0;i<MixedPointsCount;i++) {
		WorkCopyPoints[i].x = MixedPoints[i].x;
		WorkCopyPoints[i].top_y = MixedPoints[i].top_y;
		WorkCopyPoints[i].bot_y = MixedPoints[i].bot_y;
        WorkCopyPoints[i].top = MixedPoints[i].top;

	}

	 return 1;
}

void __fastcall TProfile::reverse_array(float *array,int count) {
   float tmp;
   for(int i=0;i<=count/2;i++) {
	   tmp  = array[i];
	   array[i] = array[count-i];
	   array[count-i] = tmp ;
   }

}

int  __fastcall TProfile::insert_in_array(float *array,int count,float value) {

   int i,j;
   for(i=0;i<count;i++)
	if(array[i]>=value) break;
   for(j=count;j>i;j--)
	  array[j] = array[j-1];
   array[i] = value ;
   return i;

}
void __fastcall TProfile::insert_in_array_pos(float *array,int count,int pos,float value) {

   int j;
   for(j=count;j>pos;j--)
	  array[j] = array[j-1];
   array[pos] = value ;

}

int __fastcall TProfile::IsLoaded(void) {

	 return isloaded;
}

void __fastcall TProfile::RotateOnChord(float angle)  {

	for(int i=0; i<PointCount; i++) {
		RotatedPointsY[i] = PointsY[i]*sin(angle);
		RotatedPointsZ[i] = PointsY[i]*cos(angle);
		RotatedPointsX[i] = PointsX[i];

	}
}

float __fastcall TProfile::GetRPointX(int Index) {

	   return RotatedPointsX[Index];
	}
float __fastcall TProfile::GetRPointY(int Index) {
	   return RotatedPointsY[Index];
	}
float __fastcall TProfile::GetRPointZ(int Index) {
	   return RotatedPointsZ[Index];
	}

void  __fastcall TProfile::SetMaxDepth(float th) {
	float ratio = th/MaxDepth;
	for(int i=0;i<MixedPointsCount;i++) {
		WorkCopyPoints[i].top_y = MixedPoints[i].top_y*ratio;
		WorkCopyPoints[i].bot_y = MixedPoints[i].bot_y*ratio;
	}

	float depth = 0.0;
	WorkMaxDepth = 0.0;
	for(int i=0;i<MixedPointsCount;i++)
	{

	 depth = fabs(WorkCopyPoints[i].top_y - WorkCopyPoints[i].bot_y);//GetDepthAt(TopPointsX[i]);
	 if(depth>WorkMaxDepth) {
		WorkMaxDepth = Roundf(depth,5);
		WorkDepthPosition = WorkCopyPoints[i].x;
		  }
	}

	return;
}
void  __fastcall TProfile::SetMaxDepthPosition(float pos) {
	float ratio = pos/MaxDepthPosition;
	int i=MixedPointsCount-1;
		while(MixedPoints[i].x<=MaxDepthPosition) {
			  WorkCopyPoints[i].x = MixedPoints[i].x*ratio;
			  i--;
		}


  ratio = (1.0-pos)/(1.0-MaxDepthPosition);
	for(;i>=0;i--)
	 WorkCopyPoints[i].x = pos+(MixedPoints[i].x-MaxDepthPosition)*ratio;

 	float depth = 0.0;
	WorkMaxDepth = 0.0;
	for(int i=0;i<MixedPointsCount;i++)
	{

	 depth = fabs(WorkCopyPoints[i].top_y - WorkCopyPoints[i].bot_y);//GetDepthAt(TopPointsX[i]);
	 if(depth>WorkMaxDepth) {
		WorkMaxDepth = Roundf(depth,5);
		WorkDepthPosition = WorkCopyPoints[i].x;
		  }
	}


}

//float __fastcall TProfile::GetDepthAtTopPoint(int i) {
//
//}


float __fastcall TProfile::GetDepthAt(float pos) {
   int i=0;
   float a,b;
   for (i=1; i <= TopPointsCount; i++)
	if(TopPointsX[i]<=pos && TopPointsX[i-1]>=pos) break;
   if(i==TopPointsCount) return 0.0;

   if(TopPointsX[i]!=TopPointsX[i-1])
	  a = (TopPointsY[i] - TopPointsY[i-1])/(TopPointsX[i] - TopPointsX[i-1]);
   else a = 0.0;
   b =  TopPointsY[i] - a*TopPointsX[i];

   float d1 = a*pos+b;



   for (i=1; i <= BottomPointsCount; i++)
	if(BottomPointsX[i]>=pos && BottomPointsX[i-1]<=pos) break;
   if(i==BottomPointsCount) return 0.0;
   if(BottomPointsX[i]!=BottomPointsX[i-1])
   a = (BottomPointsY[i] - BottomPointsY[i-1])/(BottomPointsX[i] - BottomPointsX[i-1]);
   else a = 0.0;
   b =  BottomPointsY[i] - a*BottomPointsX[i];

   float d2 = a*pos+b;

	return d1-d2;
}

float __fastcall  TProfile::GetY(float x1,float y1, float x2 ,float y2, float pos) {

	float a,b;
   if(pos<x2 || pos>x1) {
	AnsiString bb = "GetY out of bounds: x1=" + AnsiString(x1) + " x2=" + AnsiString(x2) + " pos=" + AnsiString(pos);
   //	Debug(bb);
   }
   if(x1!=x2)
	  a = (y1 - y2)/(x1 - x2);
   else a = 0.0;
   b =  y1 - a*x1;

   float d1 = a*pos+b;

   return d1;

}
