//---------------------------------------------------------------------------
#include <system.hpp>
#include <Classes.hpp>

#ifndef TProfileH
#define TProfileH
//---------------------------------------------------------------------------

typedef struct {
		float    x,top_y,bot_y;
		int		top;

		}   point;

typedef struct {
		double    x,y;
		}   point2d;

class TProfile
{


private:	// User declarations
	AnsiString Name;
//	point *Points;
//	point *NormalizedPoints;
	int PointCount;
	TStringList *FileStrings;
	float  PointsX[200];
	float  PointsY[200];

	float  TopPointsX[200];
	float  TopPointsY[200];

	float  BottomPointsX[200];
	float  BottomPointsY[200];


	point MixedPoints[400];
	point WorkCopyPoints[400];

	float WorkMaxDepth;
	float WorkDepthPosition;
	int 	MixedPointsCount;

	float  RotatedPointsX[200];
	float  RotatedPointsY[200];
	float  RotatedPointsZ[200];

	float   MaxDepth;
	float	MaxDepthPosition;
	int 	isloaded;

	int		TopPointsCount;
	int 	BottomPointsCount;

	void __fastcall reverse_array(float *array,int count);
	int  __fastcall insert_in_array(float *array,int count,float value);
	void __fastcall insert_in_array_pos(float *array,int count, int pos,float value);
public:		// User declarations
	 __fastcall TProfile(void);
	int __fastcall LoadFromFile(AnsiString FileName);
	int __fastcall Normalize(void);
	AnsiString __fastcall GetName(void);
	float __fastcall GetPointX(int Index);
	float __fastcall GetPointY(int Index);
	float __fastcall GetX(int Index) { return WorkCopyPoints[Index].x; };
	float __fastcall GetTopY(int Index) { return WorkCopyPoints[Index].top_y; };
	float __fastcall GetBottomY(int Index) { return WorkCopyPoints[Index].bot_y; };
	int	  __fastcall GetMixedCount(void) { return MixedPointsCount; }

	int __fastcall GetMixedPointState(int Index) { return WorkCopyPoints[Index].top; };

	int __fastcall GetPointCount(void);
	int __fastcall IsLoaded(void);
	void __fastcall RotateOnChord(float angle);
	float __fastcall GetRPointX(int Index);
	float __fastcall GetRPointY(int Index);
	float __fastcall GetRPointZ(int Index);
	float __fastcall GetMaxDepth(void) { return WorkMaxDepth; }; // return in range 0 - 1
	float __fastcall GetMaxDepthPosition(void) { return WorkDepthPosition; }; // return in range 0 - 1
	void  __fastcall SetMaxDepth(float th); // return in range 0 - 1
	void  __fastcall SetMaxDepthPosition(float pos); // return in range 0 - 1
	float __fastcall GetDepthAt(float pos);
	float __fastcall GetY(float x1,float y1, float x2 ,float y2, float pos);

};



//---------------------------------------------------------------------------
#endif
