/*************************************************************************
Copyright (c) 2005-2007, Sergey Bochkanov (ALGLIB project).

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

- Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

- Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer listed
  in this license in the documentation and/or other materials
  provided with the distribution.

- Neither the name of the copyright holders nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*************************************************************************/

#include <stdafx.h>
#include "bezier.h"

/*************************************************************************
  .

:
    N       -     
    XA, YA  -        0  N.
    T       - ,    .  0  1.
    
:
    X,Y     -   
*************************************************************************/
void beziercurve(const int& n,
     ap::real_1d_array xa,
     ap::real_1d_array ya,
     const double& t,
     double& x,
     double& y)
{
    int i;
    int c;
    double p;

    c = 1;
    for(i = 0; i <= n; i++)
    {
        xa(i) = xa(i)*c;
        ya(i) = ya(i)*c;
        c = (n-i)*c/(i+1);
    }
    p = 1;
    for(i = 0; i <= n; i++)
    {
        xa(i) = xa(i)*p;
        ya(i) = ya(i)*p;
        p = p*t;
    }
    p = 1;
    for(i = n; i >= 0; i--)
    {
        xa(i) = xa(i)*p;
        ya(i) = ya(i)*p;
        p = p*(1-t);
    }
    x = 0;
    y = 0;
    for(i = 0; i <= n; i++)
    {
        x = x+xa(i);
        y = y+ya(i);
    }
}



