//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "TProfile.h"
#include "Support.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TOpenGLAPPanel"
#pragma resource "*.dfm"
TForm1 *Form1;


typedef enum {
	MB_DOWN,
	MB_UP
	} Emouse;


	TMouseButton MouseButton;
	Emouse       MouseStatus  = MB_UP;
	long         MPosX, MPosY = 0;

bool displaymode = true;
// rows position
double A = 0.09 ,B = 0.25,C = 0.65 ,Z = 0.97 ;
// angles from prev row startin from a->z
double BAngle, CAngle, ZAngle;
//ratios
double BRatio = 0.5, CRatio = 0.25 , ZRatio = 1.0 ;

double L = -.0 ;
AnsiString pname;
 point BendedPoints[400];

#define Line2d(x,y,x1,y1)    glVertex3f(x*ratio+10, height+y*ratio+10-height/2, 0.0f); glVertex3f(x1*ratio+10, height+y1*ratio+10-height/2, 0.0f);

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
isGradient = true;
CRatio = ZRatio/2;
BRatio = CRatio/3;


}
//---------------------------------------------------------------------------
void __fastcall TForm1::OpenGLAPPanel1Init(TObject *Sender)
{

	OpenGLAPPanel1->MakeOpenGLPanelCurrent();
	glViewport(0,0,(GLsizei)OpenGLAPPanel1->Width,(GLsizei)OpenGLAPPanel1->Height);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_AUTO_NORMAL);
	glDisable(GL_POLYGON_SMOOTH);
	glEnable(GL_ALPHA_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

//   glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_DONT_CARE);
	glClearColor(0.4f,0.4f,0.4f,1.0f);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenGLAPPanel1Paint(TObject *Sender)
{
// GLint Viewport [4];
//  int width, height;
	glClearGradient();
//	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
 //	glLoadIdentity();
  // get the viewport
//  glGetIntegerv ( GL_VIEWPORT, Viewport );
//	width = Viewport[2]-20;
//	height = Viewport[3]-20;

//	glBegin(GL_LINES);
//	glEnd();


}
//---------------------------------------------------------------------------
inline double BezierFunc(double p[],int i,double t)
{
double s=1-t,
	 t2=t*t,
	 t3=t2*t;
return ((p[3*i]*s+3*t*p[3*i+1])*s+3*t2*p[3*i+2])*s+t3*p[3*i+3];
}
/*
Procedure Catmull_Rom_Spline (NumPoints : Word; Var Points : Array Of Point;
Segments : Word);
{ Draw a spline approximating a curve defined by the array of points.   }
{ In contrast to the BSpline this curve will pass through the points    }
{ defining is except the first and the last point. The curve will only  }
{ pass through the first and the last point if these points are given   }
{ twice after eachother, like this :                                    }
{ Array of points :                                                     }
{                                                                       }
{  First point defined twice           Last point defined twice         }
{   |-----|                                |----------|                 }
{ (0,0),(0,0),(100,100),....,(150,100),(200,200),(200,200)              }
{ the curve defined by these points will pass through all the points.   }
*/
float  _Calculate (float mu, float p0, float p1, float p2, float p3) {

  float mu2, mu3 ,res;


  mu2 = mu*mu;
  mu3 = mu2*mu;
  res =  ((1/2.0)*(mu3*(-p0+3.0*p1-3.0*p2+p3) + mu2*(2.0*p0-5.0*p1+4.0*p2-p3) +  mu*(-p0+p2)+(2.0*p1)));
  return res;
  }



//---------------------------------------------------------------------------

void __fastcall TForm1::Draw2D(void) {

			   float hs, ch,width,height,ratio,r_tmp;
 GLint Viewport [4];

  // get the viewport
  glGetIntegerv ( GL_VIEWPORT, Viewport );
 width = Viewport[2]-20;
 height = Viewport[3]-20;

 hs = 1.0;// Kite.Profiles[0]GetHalfSpan();
// ch =  Kite.Profiles[0].GetMaxDepth();

 ratio = width/hs;
// r_tmp = height/ch;
// if(ratio>r_tmp) ratio = r_tmp;

double xa[] = {0.0,0.3,0.75,1.0,1.0};
double ya[] = {0.0,(-.05),-.1,-.2,-.2};

  bool incorrect = false;
//double xs= 0.0,ys=0.0,dt;
 double ax,ay,bx,by,cx,cy,zx,zy,tx,ty ;

 double ShrinkRatio = 1.0;

 double sina = (BRatio*L) /(B-A) ;
 double sinb = (CRatio*L - BRatio*L)/(C-B);
 double sinz =  (ZRatio*L - CRatio*L)/(Z-C);
 if(fabs(sina)>=.9)  {   incorrect = true;
  if(sina>0) sina = 0.9; else sina =-0.9;
 }
 if(fabs(sinb)>=.9)   {   incorrect = true;
  if(sinb>0) sinb = 0.9; else sinb =-0.9;
 }
 if(fabs(sinz)>=.9)     {   incorrect = true;
  if(sinz>0) sinz = 0.9; else sinz =-0.9;
 }

	 glBegin(GL_LINES);
	glLineWidth(1.0);
	glColor4f(0.0,1.0,0.0,0.8);
	Line2d(0.0,0.0,1.0,0.0);

	glColor4f(0.0,1.0,1.0,0.8);




  // draw A circle & place start point                       /
  DrawCircle2D(A*ratio+10, height+10-height/2,3);
  // calc B row position

  BAngle = asin( sina );



   bx = A+(B-A)*cos(BAngle) ;
   by = 0.0+(B-A)*sin(BAngle) ;
   Line2d(A,0.0,bx,by);
   DrawCircle2D(bx*ratio+10, height+by*ratio+10-height/2,3);


   ax = A + A*cos(BAngle+M_PI) ;
   ay = A*sin(BAngle+M_PI) ;

   Line2d(A,0.0,ax,ay);
   CAngle = asin(sinb);

   cx = bx + (C-B)*cos(CAngle) ;
   cy = by+ (C-B)*sin(CAngle) ;

   Line2d(bx,by,cx,cy);
   DrawCircle2D(cx*ratio+10, height+cy*ratio+10-height/2,3);

  ZAngle = asin(sinz);

   zx = cx + (Z-C)*cos(ZAngle) ;
   zy = cy + (Z-C)*sin(ZAngle) ;

   Line2d(cx,cy,zx,zy);
   DrawCircle2D(zx*ratio+10, height+zy*ratio+10-height/2,3);


   tx = cx + (1.0-C)*cos(ZAngle) ;
   ty = cy + (1.0-C)*sin(ZAngle) ;



   Line2d(tx,ty,zx,zy);

  // Line2d((cx + (1.0-C)*cos(ZAngle)),(cy + (1.0-C)*sin(ZAngle)),zx,zy);


	double angle  = atan(-(ay - (cy + (1.0-C)*sin(ZAngle)))/(ax - (cx + (1.0-C)*cos(ZAngle))));


   ShrinkRatio = 1.0/((tx-ax)*cos(angle) - (ty-ay)*sin(angle)) ;

	AnsiString faa = floor(angle/M_PI*180);
	if(!incorrect) {
		faa = "Angle = " + faa;
	glColor4f(1.0,1.0,0.0,0.8);
	}
	 else      	{
	 faa = "Angle is oversized";
	  glColor4f(1.0,0.0,0.0,0.8);

	 }
   glEnd();
	glRasterPos3f(10, height+ 10, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	faa = floor(L*100);
	faa = "Sheeting = " + faa + "% of chord";

	glRasterPos3f(10, height, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	faa = A*100.0;
	faa = "A at " + faa + "%";
	glRasterPos3f(10, height-10, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	faa = B*100.0;
	faa = "B at " + faa + "%";
	glRasterPos3f(10, height-20, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	faa = C*100.0;
	faa = "C at " + faa + "%";
	glRasterPos3f(10, height-30, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	faa = Z*100.0;
	faa = "Z at " + faa + "%";
	glRasterPos3f(10, height-40, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	if(BRatio==0) faa = 0;
	else faa =  CRatio/BRatio;

	faa = "B -> C ratio =  " + faa;
	glRasterPos3f(10, height-50, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	if(CRatio==0) faa = 0;
	else  faa =  ZRatio/CRatio;
	faa = "C -> Z ratio =  " + faa;
	glRasterPos3f(10, height-60, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);

	faa =  ZRatio;
	faa = "Z ratio =  " + faa;
	glRasterPos3f(10, height-70, 0.0f);
	OpenGLAPPanel1->Draw2DText(faa);


	glRasterPos3f(A*ratio+10, height+10-height/2+7, 0.0f);
	OpenGLAPPanel1->Draw2DText("A");

	glRasterPos3f(B*ratio+10, height+10-height/2+7, 0.0f);
	OpenGLAPPanel1->Draw2DText("B");

	glRasterPos3f(C*ratio+10, height+10-height/2+7, 0.0f);
	OpenGLAPPanel1->Draw2DText("C");

	glRasterPos3f(Z*ratio+10, height+10-height/2+7, 0.0f);
	OpenGLAPPanel1->Draw2DText("Z");

	glRasterPos3f(width - 150, 27, 0.0f);
	OpenGLAPPanel1->Draw2DText("(c) Jazz  sikamika@gmail.com");

	glRasterPos3f(10, height-80, 0.0f);
	faa = "Original Name: "+Profile.GetName();
	OpenGLAPPanel1->Draw2DText(faa);

	glRasterPos3f(10, height-90, 0.0f);
	if(BRatio!=0)
	{ faa =  Profile.GetName()+ " "+1/BRatio+1/CRatio+1/ZRatio+" ang "+ floor(angle/M_PI*180);

	}else
	faa = Profile.GetName()+ " 001 ang "+ floor(angle/M_PI*180);
	 pname = faa;
	OpenGLAPPanel1->Draw2DText(faa);



	glBegin(GL_LINES);

	point2d Points[7];// = {{1,2},{2,3}};
	point2d SplinedPoints[100];

	Points[0].x = 0.0;
	Points[0].y = 0.0;
	Points[1].x = 0.0;
	Points[1].y = 0.0;
// A point
	Points[2].x = ((bx-ax)*cos(angle) - (by-ay)*sin(angle)) * ShrinkRatio;
	Points[2].y = ((bx-ax)*sin(angle) + (by-ay)*cos(angle));

// B point
	Points[3].x = ((cx-ax)*cos(angle) - (cy-ay)*sin(angle)) * ShrinkRatio;
	Points[3].y = ((cx-ax)*sin(angle) + (cy-ay)*cos(angle));

// C point
	Points[4].x = ((zx-ax)*cos(angle) - (zy-ay)*sin(angle)) * ShrinkRatio;
	Points[4].y = ((zx-ax)*sin(angle) + (zy-ay)*cos(angle));

//last point
	Points[5].x = ((tx-ax)*cos(angle) - (ty-ay)*sin(angle)) * ShrinkRatio;// 1.0;
	Points[5].y = ((tx-ax)*sin(angle) + (ty-ay)*cos(angle));// 0.0;

	Points[6].x = 1.0;
	Points[6].y = 0.0;


	 glVertex3f(10, height+10-height/2,0.0);
	 glVertex3f(((bx-ax)*cos(angle) - (by-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((bx-ax)*sin(angle) + (by-ay)*cos(angle))*ratio+10-height/2,0.0);

	 glVertex3f(((bx-ax)*cos(angle) - (by-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((bx-ax)*sin(angle) + (by-ay)*cos(angle))*ratio+10-height/2,0.0);
	 glVertex3f(((cx-ax)*cos(angle) - (cy-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((cx-ax)*sin(angle) + (cy-ay)*cos(angle))*ratio+10-height/2,0.0);

	 glVertex3f(((cx-ax)*cos(angle) - (cy-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((cx-ax)*sin(angle) + (cy-ay)*cos(angle))*ratio+10-height/2,0.0);
	 glVertex3f(((zx-ax)*cos(angle) - (zy-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((zx-ax)*sin(angle) + (zy-ay)*cos(angle))*ratio+10-height/2,0.0);

	 glVertex3f(((zx-ax)*cos(angle) - (zy-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((zx-ax)*sin(angle) + (zy-ay)*cos(angle))*ratio+10-height/2,0.0);
//	 glVertex3f(1.0*ratio+10, height+0.0*ratio+10-height/2,0.0);
	 glVertex3f(((tx-ax)*cos(angle) - (ty-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((tx-ax)*sin(angle) + (ty-ay)*cos(angle))*ratio+10-height/2,0.0);



//	 DrawCircle2D(10, height+10-height/2,3);

 //	 DrawCircle2D((A*cos(angle)-ax)*ratio * ShrinkRatio+10, height+(A*sin(angle)-ay)*ratio+10-height/2,3);


	 DrawCircle2D(((bx-ax)*cos(angle) - (by-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((bx-ax)*sin(angle) + (by-ay)*cos(angle))*ratio+10-height/2,3);

	 DrawCircle2D(((cx-ax)*cos(angle) - (cy-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((cx-ax)*sin(angle) + (cy-ay)*cos(angle))*ratio+10-height/2,3);

	 DrawCircle2D(((zx-ax)*cos(angle) - (zy-ay)*sin(angle))*ratio * ShrinkRatio+10, height+((zx-ax)*sin(angle) + (zy-ay)*cos(angle))*ratio+10-height/2,3);
	// DrawCircle2D(((tx-ax)*cos(angle) - (ty-ay)*sin(angle))*ratio+10, height+((tx-ax)*sin(angle) + (ty-ay)*cos(angle))*ratio+10-height/2,3);

	glColor4f(1.0,1.0,1.0,0.8);


//  -----------
//  draw spline
//	-------------
  float mu, mudelta;
  float x1, y1, x2, y2;
  int n, h ;
  int Segments = 20 ;
  int NumPoints = 7;
  int spp = 0;

  mudelta = 1.0/Segments;
  for( n=3 ; n <= NumPoints-1 ; n++) {
	mu=0;
	x1=_Calculate (mu,Points[n-3].x,Points[n-2].x,Points[n-1].x,Points[n].x);
	y1=_Calculate (mu,Points[n-3].y,Points[n-2].y,Points[n-1].y,Points[n].y);
	mu = mu+mudelta;
	for(h=1 ; h<=Segments; h++) {
	  x2 = _Calculate (mu,Points[n-3].x,Points[n-2].x,Points[n-1].x,Points[n].x);
	  y2 = _Calculate (mu,Points[n-3].y,Points[n-2].y,Points[n-1].y,Points[n].y);
   //	  Line2d(x1, y1, x2, y2);
	  if(x2!=0.0 && y2!=0.0 && x2!=1.0) {
			SplinedPoints[spp].x = x2;
			SplinedPoints[spp].y = y2;
			 spp++;
	  }
	  //	glVertex3f(x1*ratio+10, height+y1*ratio+10-height/2, 0.0f);
	  //	glVertex3f(x2*ratio+10, height+y2*ratio+10-height/2, 0.0f);
	  mu= mu+mudelta;
	  x1=x2;
	  y1=y2;
	}
  }






  #define MAX 100
#define N 18
#define ZOOM 2

  /*

		   for (int i = 0; i < 1  ; i++)   {     // i < a/3

		   for(int j=0;j<=N;j++) {
			 dt=(double)j/(double)N;
			 xs = BezierFunc(xa,i,dt);
			 ys = BezierFunc(ya,i,dt);

			glVertex3f(xs*ratio+10, height+ys*ratio+10-height/2, 0.0f);

		   }
		 }


	*/
	glEnd();

 if(!Profile.IsLoaded()) return;

	glBegin(GL_LINES);

			   glLineWidth(1.0);

			float x,y,prevx=1.0,prevy=0.0;
			int count = Profile.GetMixedCount();
			  // prevx = Kite.Profiles[0].GetX(0);
			  // prevy = Kite.Profiles[0].GetTopY(0);
			   glColor4f(1.0,1.0,0.0,0.5);

			for(int i=0; i<count; i++) {

			   x = Profile.GetX(i);
			   y = Profile.GetTopY(i);
			//   BendedPoints[i].x = x;
			//   BendedPoints[i].top_y = y;

				Line2d(x,y,prevx,prevy);
				prevx = x;
				prevy = y;

				}

			count = Profile.GetMixedCount();
			   prevx = 1.0;//Kite.Profiles[0].GetX(0);
			   prevy = 0.0;// Kite.Profiles[0].GetBottomY(0);

			for(int i=1; i<count; i++) {

			   x = Profile.GetX(i);
			   y = Profile.GetBottomY(i);
			//   BendedPoints[i].bot_y = y;
			   Line2d(x,y,prevx,prevy);
				prevx = x;
				prevy = y;

				}

// draw middle line
			count = Profile.GetMixedCount();
			   prevx = 1.0;//Kite.Profiles[0].GetX(0);
			   prevy = 0.0;// Kite.Profiles[0].GetBottomY(0);
			   glColor4f(1.0,0.0,1.0,0.8);

			for(int i=1; i<count; i++) {

			   x = Profile.GetX(i);
			   y = (Profile.GetTopY(i) + Profile.GetBottomY(i))/2.0;
			   Line2d(x,y,prevx,prevy);
				prevx = x;
				prevy = y;

				}

// try to draw bended profile
			   float px = 1.0;//Kite.Profiles[0].GetX(0);
			   float pyt = 0.0,pyb=0.0,pym=0.0; // Kite.Profiles[0].GetBottomY(0);
			   int j;
			   float yb;

			for(int i=1; i<count; i++) {
				 x = Profile.GetX(i);

				 for(j=0;j<spp;j++) {
					 if(x>=SplinedPoints[j].x && x<SplinedPoints[j+1].x ) break;
					 //if(x>SplinedPoints[j].x && x<=SplinedPoints[j+1].x ) break;
				 }
				 if(j==spp) {

				 y = Profile.GetTopY(i);
				 yb = Profile.GetBottomY(i);
				 }  else {

				 y = Profile.GetTopY(i) + SplinedPoints[j].y+ (SplinedPoints[j+1].y-SplinedPoints[j].y)*(x-SplinedPoints[j].x)/(SplinedPoints[j+1].x-SplinedPoints[j].x) ;
				 yb = Profile.GetBottomY(i) + SplinedPoints[j].y+ (SplinedPoints[j+1].y-SplinedPoints[j].y)*(x-SplinedPoints[j].x)/(SplinedPoints[j+1].x-SplinedPoints[j].x) ;


				// y = Profile.GetTopY(i) + (SplinedPoints[j].y+ SplinedPoints[j+1].y)/2.0;
				// yb = Profile.GetBottomY(i)+ (SplinedPoints[j].y+ SplinedPoints[j+1].y)/2.0;
				}

				  glColor4f(1.0,1.0,1.0,1.0);

				  BendedPoints[i].x = x;
				  BendedPoints[i].top_y = y;
				  BendedPoints[i].bot_y = yb;
  if(displaymode) {
				  Line2d(x,y,px,pyt);
				  Line2d(x,yb,px,pyb);
				  Line2d(x,(yb+y)/2.0,px,pym);
  } else {
//   ((bx-ax)*cos(angle) - (by-ay)*sin(angle))
 //                                             (cx-ax)*sin(angle) + (cy-ay)*cos(angle)
			 //  angle *=1.01;
			  Line2d((ax+((x/ShrinkRatio)*cos(-angle)-(y)*sin(-angle))),(ay+(x/ShrinkRatio)*sin(-angle)+(y)*cos(-angle)),(ax+((px/ShrinkRatio)*cos(-angle)-(pyt)*sin(-angle))),(ay+(px/ShrinkRatio)*sin(-angle)+(pyt)*cos(-angle)));
			  Line2d((ax+((x/ShrinkRatio)*cos(-angle)-(yb)*sin(-angle))),(ay+(x/ShrinkRatio)*sin(-angle)+(yb)*cos(-angle)),(ax+((px/ShrinkRatio)*cos(-angle)-(pyb)*sin(-angle))),(ay+(px/ShrinkRatio)*sin(-angle)+(pyb)*cos(-angle)));
			  Line2d((ax+((x/ShrinkRatio)*cos(-angle)-((yb+y)/2.0)*sin(-angle))),(ay+(x/ShrinkRatio)*sin(-angle)+((yb+y)/2.0)*cos(-angle)),(ax+((px/ShrinkRatio)*cos(-angle)-(pym)*sin(-angle))),(ay+(px/ShrinkRatio)*sin(-angle)+(pym)*cos(-angle)));
		  }

			  //	  glColor4f(1.0,0.0,0.0,0.5);
			  //	  Line2d(x,(yb+y)/2.0,px,pym);



				  px = x;
				  pyt = y;
				  pyb = yb;
				  pym =  (yb+y)/2.0;

				}







glEnd();




	return;
}

void __fastcall TForm1::OpenGLAPPanel1Resize(TObject *Sender)
{
	OpenGLAPPanel1->MakeOpenGLPanelCurrent();
	glViewport(0,0,(GLsizei)OpenGLAPPanel1->Width,(GLsizei)OpenGLAPPanel1->Height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

   //gluPerspective(60.0f, fAspect, 1.0, 425.0);
//	if (Height==0)
 //		gluPerspective(45, (GLdouble)OpenGLAPPanel1->Width, zNear, zFar);
 //	else
 //		gluPerspective(45, (GLdouble)OpenGLAPPanel1->Width/
 //						   (GLdouble)OpenGLAPPanel1->Height,zNear, zFar);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Open1Click(TObject *Sender)
{
if(OpenDialog1->Execute()) Profile.LoadFromFile(OpenDialog1->FileName);
OpenGLAPPanel1->Repaint();

}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenGLAPPanel1MouseDown(TObject *Sender,
	  TMouseButton Button, TShiftState Shift, int X, int Y)
{
	MouseButton = Button;
	MouseStatus = MB_DOWN;
	// Init Mouse Position On Button Click
	MPosX = X;
	MPosY = Y;


}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenGLAPPanel1MouseMove(TObject *Sender,
	  TShiftState Shift, int X, int Y)
{
	if (MouseButton == mbLeft &&
		MouseStatus ==  MB_DOWN) {

		if (Y > MPosY ) L += (Y-MPosY)/100.0;
		if (Y < MPosY ) L -= (MPosY-Y)/100.0;
		MPosX = X;
		MPosY = Y;
		OpenGLAPPanel1->Repaint ();

	}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenGLAPPanel1MouseUp(TObject *Sender,
	  TMouseButton Button, TShiftState Shift, int X, int Y)
{
	MouseButton = Button;
	MouseStatus = MB_UP;
	// Init Mouse Position On Button Click
	MPosX = X;
	MPosY = Y;

}
//---------------------------------------------------------------------------


void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
CRatio = ZRatio/2;
BRatio = CRatio/2;
OpenGLAPPanel1->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
CRatio = ZRatio/2;
BRatio = CRatio/3;
OpenGLAPPanel1->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton3Click(TObject *Sender)
{
CRatio = ZRatio/3;
BRatio = CRatio/3;
OpenGLAPPanel1->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton4Click(TObject *Sender)
{
CRatio = 0;
BRatio = 0;
OpenGLAPPanel1->Repaint();
}
//---------------------------------------------------------------------------



void __fastcall TForm1::UpDown1Changing(TObject *Sender, bool &AllowChange)
{
if(UpDown1->Position<UpDown2->Position) {
	Arowcaption->Caption = AnsiString(UpDown1->Position) + "%";
	A = UpDown1->Position/100.0;
	OpenGLAPPanel1->Repaint();
	AllowChange = true;
	} else AllowChange = false;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::UpDown2Changing(TObject *Sender, bool &AllowChange)
{
 if(UpDown2->Position<UpDown3->Position && UpDown2->Position>UpDown1->Position ) {
	Label4->Caption = AnsiString(UpDown2->Position) + "%";
	B = UpDown2->Position/100.0;
	OpenGLAPPanel1->Repaint();
	AllowChange = true;
	}  else AllowChange = false;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDown3Changing(TObject *Sender, bool &AllowChange)
{
	if(UpDown3->Position<UpDown4->Position && UpDown3->Position>UpDown2->Position ) {
	Label6->Caption = AnsiString(UpDown3->Position) + "%";
	C = UpDown3->Position/100.0;
	OpenGLAPPanel1->Repaint();
	AllowChange = true;
	}  else AllowChange = false;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDown4Changing(TObject *Sender, bool &AllowChange)
{
	if( UpDown4->Position>UpDown3->Position ) {
	Label8->Caption = AnsiString(UpDown4->Position) + "%";
	Z = UpDown4->Position/100.0;
	OpenGLAPPanel1->Repaint();
	AllowChange = true;
	}  else AllowChange = false;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::SpeedButton6Click(TObject *Sender)
{
TStringList *FileStrings;

if(!Profile.IsLoaded()) return;
FileStrings = new TStringList();
FileStrings->Add(pname);
FileStrings->Add("1.00000  0.00000" ) ;
AnsiString t;
int 	count = Profile.GetMixedCount();

		for(int i=1; i<count; i++) {
				 if(BendedPoints[i].x>0.00000f) {
				 t.sprintf("%f6 %f6",BendedPoints[i].x,BendedPoints[i].bot_y);
				 FileStrings->Add(t)   ;
				 }
				}
FileStrings->Add("0.00000  0.00000") ;

		for(int i=1; i<count; i++) {
				if(BendedPoints[count-i].x>0.00000f) {
				 t.sprintf("%f6 %f6",BendedPoints[count-i].x,BendedPoints[count-i].top_y);
				FileStrings->Add(t)     ;
                }
				}

 FileStrings->Add("1.00000  0.00000") ;
 SaveDialog1->FileName = pname +".dat";
   if(SaveDialog1->Execute()) FileStrings->SaveToFile(SaveDialog1->FileName);
OpenGLAPPanel1->Repaint();
delete(FileStrings);
}
//---------------------------------------------------------------------------



void __fastcall TForm1::RadioButton2Click(TObject *Sender)
{
if(RadioButton2->Checked )displaymode = false;
 else   displaymode = true;
 OpenGLAPPanel1->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioButton1Click(TObject *Sender)
{
if(RadioButton2->Checked )displaymode = false;
 else   displaymode = true;
 OpenGLAPPanel1->Repaint();
}
//---------------------------------------------------------------------------

